Imports System
Imports System.Runtime.Serialization
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.IO
Imports System.Collections

'
' Klasa TextFileReader zapewnia dostp do plikw tekstowych  wydobywa acuchy
' zawierajce n nastpnych lub poprzednich wierszy. TextFileReader jest dobrym
' przykadem klasy serializowalnej (zadeklarowanej z atrybutem Serializable),
' ktra odwouje si do nieserializowalnych obiektw. W szczeglnoci, klasa
' TextFileReader wykorzystuje obiekt klasy FileStream, ktry nie moe by
' serializowany. Poniewa wykorzystywanego obiektu klasy FileStream nie mona
' zapisa bezporednio w pliku, zapisujemy tylko nazw pliku i biec pozycj
' w ramach pliku reprezentowanego przez ten obiekt.
'
<Serializable()> Public Class TextFileReader
    Implements ISerializable

    <NonSerialized()> Private file As FileStream
    Private myFilename As String
    Private stack As FilePositionStack

    '
    ' Konstruuje obiekt klasy TextFileReader, ktry bdzie odczytywaa zawarto
    ' wskazanego pliku.
    '
    ' name - Nazwa nazwa pliku, ktrego zawarto bdzie odczytywana przez ten obiekt.
    Public Sub New(ByVal name As String)
        myFilename = name
        file = New FileStream(myFilename, FileMode.Open)
        stack = New FilePositionStack()
    End Sub 'New

    ' Konstruktor deserializacji.
    Public Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
        myFilename = info.GetString("myFilename")
        Dim pos As Integer = info.GetInt32("position")
        stack = CType(info.GetValue("stack", GetType(FilePositionStack)), FilePositionStack)
        file = New FileStream(myFilename, FileMode.Open)
        file.Seek(pos, SeekOrigin.Begin)
    End Sub 'New

    Public Function readLine() As String
        Dim r As New StreamReader(file)
        Dim line As String = r.ReadLine()
        If line IsNot Nothing Then
            file.Position += line.Length ' Aktualizuje biec pozycj.
        End If
        Return line
    End Function 'readLine

    ' Zwraca acuch zawierajcy nastpne n wierszy tekstu zapisanego w danym pliku.
    Public Function GetNext(ByVal n As Integer) As String
        Dim lines As String = ""
        For i As Integer = n To -1 Step -1
            stack.SavePosition(file)
            Dim line As String = readLine()
            If line Is Nothing Then
                If lines.Length > 0 Then
                    Return lines
                Else
                    Throw New ApplicationException("Nie znaleziono adnego wiersza.")
                End If
            End If
            lines += line & vbCrLf
        Next i
        Return lines
    End Function 'GetNext

    '
    ' Zwraca acuch zawierajcy n wierszy tekstu zapisanych n wierszy przed
    ' biec pozycj w pliku. Jeli si okae si, e przed biec pozycj nie
    ' ma a tylu wierszy tekstu, metoda zwrci pierwszyche n wierszy zapisanych
    ' w tym pliku.
    '
    Public Function GetPrevious(ByVal n As Integer) As String
        For i As Integer = n * 2 To -1 Step -1
            stack.RestorePosition(file)
        Next i
        Return GetNext(n)
    End Function 'GetPrevious

    '
    ' Nazwa pliku tekstowego zwizanego z tym obiektem.
    '
    Public ReadOnly Property FileName() As String
        Get
            Return myFilename
        End Get
    End Property

    '
    ' Zapisuje ten obiekt we wskazanym pliku.
    '
    ' name - Nazwa nazwa docelowego pliku.
    Public Sub Save(ByVal name As String)
        Dim s As Stream = System.IO.File.Open(name, FileMode.Create)
        Dim f As New BinaryFormatter()
        f.Serialize(s, Me)
        s.Close()
    End Sub

    '
    ' Odczytuje obiekt klasy TextFileReader ze wskazanego pliku.
    '
    ' name - Nazwa nazwa pliku rdowego.
    Public Shared Function Restore(ByVal name As String) As TextFileReader
        Dim s As Stream = System.IO.File.Open(name, FileMode.Open)
        Dim f As New BinaryFormatter()
        Dim r As TextFileReader = CType(f.Deserialize(s), TextFileReader)
        s.Close()
        Return r
    End Function 'Restore

    '
    ' Ponisze metody przykrywaj domyln logik zwizan z serializacj, aby byo
    ' moliwe zapisywanie informacji, ktre umoliwi rekonstruowanie egzemplarza
    ' klasy FileStream wskazywanego przez serializowany obiekt (rekonstrukcja bdzie
    ' miaa miejsce w trakcie deserializacji tego obiektu).
    '
    Public Sub GetObjectData(ByVal info As SerializationInfo, ByVal context As StreamingContext) _
     Implements ISerializable.GetObjectData
        info.AddValue("filename", FileName)
        info.AddValue("position", file.Position)
        info.AddValue("stack", stack)
    End Sub 'GetObjectData

    ' Klasa FilePositionStack implementuje stos pozycji w pliku.
    <Serializable()> Friend Class FilePositionStack
        Private stack As Stack

        Friend Sub New()
            stack = New Stack()
        End Sub 'New


        ' Umieszcza pozycj w pliku na szczycie stosu.
        Friend Sub SavePosition(ByVal file As FileStream)
            stack.Push(file.Position)
        End Sub 'SavePosition

        ' Zdejmuje pozycj w pliku ze szczytu stosu.
        Friend Sub RestorePosition(ByVal file As FileStream)
            file.Seek(CInt(stack.Pop()), SeekOrigin.Begin)
        End Sub 'RestorePosition
    End Class 'FilePositionStack
End Class 'TextFileReader
